#include "Torus.h"

Torus::Torus()
{
}

Torus::~Torus()
{
}

void Torus::Generate(GLuint texture, int segs, double internalRad, double bodyRad)
{
	_Texture = texture;

	double internalAngle = 0.0f;
	double externalAngle = 0.0f;

	double theta = 2 * PI / segs;
	double delta = 2 * PI / segs;

	for (double i = 0; i < segs; i++)
	{
		glBegin(GL_QUADS);
		for (double j = 0; j < segs; j++)
		{
			//Vertex calculations
			Vector3 first = Vector3
			(
				(internalRad + bodyRad * cosf(internalAngle))*cosf(externalAngle),
				(internalRad + bodyRad * cosf(internalAngle))*sinf(externalAngle),
				(bodyRad*sinf(internalAngle))
			);

			Vector3 second = Vector3
			(
				(internalRad + bodyRad * cosf(internalAngle))*cosf(externalAngle + delta),
				(internalRad + bodyRad * cosf(internalAngle))*sinf(externalAngle + delta),
				(bodyRad*sinf(internalAngle))
			);

			Vector3 third = Vector3
			(
				(internalRad + bodyRad * cosf(internalAngle + theta))*cosf(externalAngle + delta),
				(internalRad + bodyRad * cosf(internalAngle + theta))*sinf(externalAngle + delta),
				(bodyRad*sinf(internalAngle + theta))
			);

			Vector3 fourth = Vector3
			(
				(internalRad + bodyRad * cosf(internalAngle + theta))*cosf(externalAngle),
				(internalRad + bodyRad * cosf(internalAngle + theta))*sinf(externalAngle),
				(bodyRad*sinf(internalAngle + theta))
			);

			//First vertex
			//Normal calculation
			Vector3 firstNormVector = Vector3(((internalRad + bodyRad * cosf(internalAngle)) * cosf(externalAngle)) - (internalRad * cos(externalAngle)),
				((internalRad + bodyRad * cosf(internalAngle)) * sinf(externalAngle)) - (internalRad * sinf(externalAngle)),
				(bodyRad * sinf(internalAngle)));
			firstNormVector.normalise();

			_Normals.push_back(firstNormVector.x);
			_Normals.push_back(firstNormVector.y);
			_Normals.push_back(firstNormVector.z);

			_TextureCoords.push_back(i / segs);
			_TextureCoords.push_back(j / segs);

			_Vertices.push_back(first.x);
			_Vertices.push_back(first.y);
			_Vertices.push_back(first.z);

			//Second vertex
			//Normal calculation
			Vector3 secondNormVector = Vector3(((internalRad + bodyRad * cosf(internalAngle)) * cosf(externalAngle + delta)) - (internalRad * cos(externalAngle + delta)),
				((internalRad + bodyRad * cosf(internalAngle)) * sinf(externalAngle + delta)) - (internalRad * sinf(externalAngle + delta)),
				(bodyRad * sinf(internalAngle)));
			secondNormVector.normalise();

			_Normals.push_back(secondNormVector.x);
			_Normals.push_back(secondNormVector.y);
			_Normals.push_back(secondNormVector.z);

			_TextureCoords.push_back((i + 1.0f) / segs);
			_TextureCoords.push_back(j / segs);

			_Vertices.push_back(second.x);
			_Vertices.push_back(second.y);
			_Vertices.push_back(second.z);

			//Third vertex
			//Normal calculation
			Vector3 thirdNormVector = Vector3(((internalRad + bodyRad * cosf(internalAngle + theta)) * cosf(externalAngle + delta)) - (internalRad * cos(externalAngle + delta)),
				((internalRad + bodyRad * cosf(internalAngle + theta)) * sinf(externalAngle + delta)) - (internalRad * sinf(externalAngle + delta)),
				(bodyRad * sinf(internalAngle + theta)));
			thirdNormVector.normalise();

			_Normals.push_back(thirdNormVector.x);
			_Normals.push_back(thirdNormVector.y);
			_Normals.push_back(thirdNormVector.z);

			_TextureCoords.push_back((i + 1.0f) / segs);
			_TextureCoords.push_back((j + 1.0f) / segs);

			_Vertices.push_back(third.x);
			_Vertices.push_back(third.y);
			_Vertices.push_back(third.z);

			//Fourth vertex
			//Normal calculation
			Vector3 fourthNormVector = Vector3(((internalRad + bodyRad * cosf(internalAngle + theta)) * cosf(externalAngle)) - (internalRad * cos(externalAngle)),
				((internalRad + bodyRad * cosf(internalAngle + theta)) * sinf(externalAngle)) - (internalRad * sinf(externalAngle)),
				(bodyRad * sinf(internalAngle + theta)));
			fourthNormVector.normalise();

			_Normals.push_back(fourthNormVector.x);
			_Normals.push_back(fourthNormVector.y);
			_Normals.push_back(fourthNormVector.z);

			_TextureCoords.push_back(i / segs);
			_TextureCoords.push_back((j + 1.0f) / segs);

			_Vertices.push_back(fourth.x);
			_Vertices.push_back(fourth.y);
			_Vertices.push_back(fourth.z);


			internalAngle += theta;
		}

		glEnd();
		externalAngle += delta;
	}
}
